@extends($activeTemplate . 'layouts.bet')
@section('bet')
    @php
        $banners = getContent('banner.element', false, null, true);
        $optionsId = collect(session()->get('bets'))->pluck('option_id')->toArray();
    @endphp

    <div class="col-12">
        <div class="banner-slider hero-slider mb-3">
            @foreach ($banners as $banner)
                <div class="banner_slide">
                    <img class="banner_image" src="{{ frontendImage('banner', @$banner->data_values->image, '1610x250') }}">
                </div>
            @endforeach
        </div>
    </div>

    <div class="col-12" id="{{ count($games) }}">
        <div class="betting-body">
            <div class="grid-line">
            </div>
            <div class="row g-3">
                <div class="grid-line">
                    @if ($page == 'home')
                        @foreach ($groupedData as $categoryData)
                            {{-- Get category info from the grouped data --}}
                            @php
                                $category = $categoryData['category'];
                                $leagues = $categoryData['leagues'];
                            @endphp
                            @if ($category->games_count > 0)
                                {{-- Display category header --}}
                                <div class="grid-line__title">
                                    <span class="league-title__flag">
                                        <img class="league-title__flag-img"
                                            src="{{ getImage(getFilePath('league') . '/' . @$category->image, getFileSize('league')) }}"
                                            alt="@lang('image')">
                                    </span>
                                    <a href="{{ route('category.games', @$category->slug) }}" class="grid-line__title-link">
                                        <div class="grid-line__title-icon">
                                            {{-- Dynamic category icon --}}
                                            {!! $category->icon !!}
                                        </div>
                                        <div class="grid-line__title-container p-1">
                                            <div class="grid-line__title-main">
                                                <span>{{ __(@$category->name) }}</span>
                                            </div>
                                        </div>
                                    </a>
                                </div>

                                {{-- Loop through each league under this category --}}
                                @foreach ($leagues as $league)
                                    {{-- Check if the league contains games --}}
                                    @if ($league->games->count() > 0)
                                        {{-- Display each game in the league --}}
                                        @foreach ($league->games as $game)
                                            <div class="grid-line__content">
                                                <div class="grid-event _with-video _no-video grid-event-pro"
                                                    role="presentation">
                                                    <div class="grid-event__title _football">
                                                        <div class="grid-event__tournament">
                                                            <div class="tournament-logo">
                                                                <img class="logo-img"
                                                                    src="{{ getImage(getFilePath('league') . '/' . @$league->image, getFileSize('league')) }}"
                                                                    alt="@lang('image')">
                                                            </div>
                                                            <a href="javascript:void(0);"
                                                                class="grid-event__tournament-name hover-underline">
                                                                {{ @$league->name }}
                                                            </a>
                                                            <span class="hot-badge"></span>
                                                        </div>
                                                        <div class="grid-event-pro__title">
                                                            <div class="grid-event__time">
                                                                <span>{{ $game->bet_start_time }}</span>
                                                            </div>
                                                            @if ($game->isRunning)
                                                                <div class="_title-icons__wrap">
                                                                    <i class="iconFont iconFont-icon-match-tracker-pro"
                                                                        style="color: red"></i>
                                                                </div>
                                                            @endif
                                                        </div>
                                                    </div>

                                                    <div class="grid-event__content">
                                                        <a href="#" class="grid-event__competitors">
                                                            <div class="grid-event__competitors-wrapper">
                                                                <div class="grid-event__competitor">
                                                                    <img src="{{ $game->teamOne->teamImage() }}"
                                                                        alt="@lang('image')" width="30"
                                                                        height="30"
                                                                        class="grid-event__competitor-logo lazyloaded">
                                                                    <div class="grid-event__competitor-wrap">
                                                                        <div class="grid-event__competitor-name">
                                                                            <span>{{ __($game->teamOne->short_name) }}</span>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="grid-event__competitors-divider">VS</div>
                                                                <div class="grid-event__competitor">
                                                                    <img src="{{ $game->teamTwo->teamImage() }}"
                                                                        alt="@lang('image')" width="30"
                                                                        height="30"
                                                                        class="grid-event__competitor-logo lazyloaded">
                                                                    <div class="grid-event__competitor-wrap">
                                                                        <div class="grid-event__competitor-name">
                                                                            <span>{{ __($game->teamTwo->short_name) }}</span>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </a>

                                                        {{-- Display the markets and options for the game --}}
                                                        @if ($game->questions->count())
                                                            @php
                                                                $firstMarket = $game->questions->first();
                                                                $showCount = 3;
                                                                $more = $game->questions->count() - $showCount;
                                                                if ($more <= 0) {
                                                                    $more = 'More..';
                                                                }
                                                                $i = 1;
                                                            @endphp
                                                            <div class="grid-markets">
                                                                <div class="grid-market _multi option-odd-lists">
                                                                    {{-- Loop through the options --}}
                                                                    @foreach ($firstMarket->options as $option)
                                                                        @if ($i == 4)
                                                                            @continue
                                                                        @endif
                                                                        <div class="option-odd-list__item">
                                                                            <button
                                                                                class="outcome equal _101 oddBtn @if (in_array($option->id, $optionsId)) active @endif @if ($option->locked) locked @endif"
                                                                                data-option_id="{{ $option->id }}"
                                                                                @disabled($game->bet_start_time >= now())
                                                                                style="order: 10{{ $i }};">
                                                                                <span
                                                                                    class="outcome__status">{{ $option->name }}</span>
                                                                                <span
                                                                                    class="outcome__number">{{ rateData($option->odds) }}</span>
                                                                            </button>
                                                                            @php
                                                                                $i++;
                                                                            @endphp
                                                                        </div>
                                                                    @endforeach
                                                                </div>
                                                                <a href="{{ route('game.markets', $game->slug) }}"
                                                                    class="grid-event-pro__totals">{{ $more }}</a>
                                                            </div>
                                                        @endif
                                                    </div>
                                                </div>
                                            </div>
                                        @endforeach
                                    @endif
                                @endforeach
                            @endif
                        @endforeach
                    @else
                        @if (@$activeLeague && $games->count())
                            <div class="grid-line__title">
                                <span class="league-title__flag">
                                    <img class="league-title__flag-img"
                                        src="{{ getImage(getFilePath('league') . '/' . @$activeLeague->image, getFileSize('league')) }}"
                                        alt="@lang('image')">
                                </span>
                                <a href="{{ route('category.games', @$activeLeague->slug) }}"
                                    class="grid-line__title-link">
                                    <div class="grid-line__title-icon">
                                        {!! $activeLeague->icon !!}
                                    </div>
                                    <div class="grid-line__title-container p-1">
                                        <div class="grid-line__title-main">
                                            <span>{{ __(@$activeLeague->name) }}</span>
                                        </div>
                                    </div>
                                </a>
                            </div>
                        @endif

                        @foreach ($games as $game)
                            <div class="grid-line__content">
                                <div class="grid-event _with-video _no-video grid-event-pro" role="presentation">
                                    <div class="grid-event__title _football">
                                        <div class="grid-event__tournament">
                                            <div class="tournament-logo">
                                                <img class="logo-img"
                                                    src="{{ getImage(getFilePath('league') . '/' . @$league->image, getFileSize('league')) }}"
                                                    alt="@lang('image')">
                                            </div>
                                            <a href="javascript:void(0);"
                                                class="grid-event__tournament-name hover-underline">
                                                {{ @$league->name }}
                                            </a>
                                            <span class="hot-badge"></span>
                                        </div>
                                        <div class="grid-event-pro__title">
                                            <div class="grid-event__time">
                                                <span>{{ $game->bet_start_time }}</span>
                                            </div>
                                            @if ($game->isRunning)
                                                <div class="_title-icons__wrap">
                                                    <i class="iconFont iconFont-icon-match-tracker-pro"
                                                        style="color: red"></i>
                                                </div>
                                            @endif
                                        </div>
                                    </div>

                                    <div class="grid-event__content">
                                        <a href="#" class="grid-event__competitors">
                                            <div class="grid-event__competitors-wrapper">
                                                <div class="grid-event__competitor">
                                                    <img src="{{ $game->teamOne->teamImage() }}" alt="@lang('image')"
                                                        width="30" height="30"
                                                        class="grid-event__competitor-logo lazyloaded">
                                                    <div class="grid-event__competitor-wrap">
                                                        <div class="grid-event__competitor-name">
                                                            <span>{{ __($game->teamOne->short_name) }}</span>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="grid-event__competitors-divider">VS</div>
                                                <div class="grid-event__competitor">
                                                    <img src="{{ $game->teamTwo->teamImage() }}" alt="@lang('image')"
                                                        width="30" height="30"
                                                        class="grid-event__competitor-logo lazyloaded">
                                                    <div class="grid-event__competitor-wrap">
                                                        <div class="grid-event__competitor-name">
                                                            <span>{{ __($game->teamTwo->short_name) }}</span>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </a>

                                        {{-- Display the markets and options for the game --}}
                                        @if ($game->questions->count())
                                            @php
                                                $firstMarket = $game->questions->first();
                                                $showCount = 3;
                                                $more = $game->questions->count() - $showCount;
                                                if ($more <= 0) {
                                                    $more = 'More..';
                                                }
                                                $i = 1;
                                            @endphp
                                            <div class="grid-markets">
                                                <div class="grid-market _multi option-odd-lists">
                                                    {{-- Loop through the options --}}
                                                    @foreach ($firstMarket->options as $option)
                                                        @if ($i == 4)
                                                            @continue
                                                        @endif
                                                        <div class="option-odd-list__item">
                                                            <button
                                                                class="outcome equal _101 oddBtn @if (in_array($option->id, $optionsId)) active @endif @if ($option->locked) locked @endif"
                                                                data-option_id="{{ $option->id }}"
                                                                @disabled($game->bet_start_time >= now())
                                                                style="order: 10{{ $i }};">
                                                                <span class="outcome__status">{{ $option->name }}</span>
                                                                <span
                                                                    class="outcome__number">{{ rateData($option->odds) }}</span>
                                                            </button>
                                                            @php
                                                                $i++;
                                                            @endphp
                                                        </div>
                                                    @endforeach
                                                </div>
                                                <a href="{{ route('game.markets', $game->slug) }}"
                                                    class="grid-event-pro__totals">{{ $more }}</a>
                                            </div>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    @endif
                </div>

            </div>
            @if (blank($games))
                <div class="empty-message mt-3">
                    <img class="img-fluid" src="{{ asset($activeTemplateTrue . 'images/empty_message.png') }}"
                        alt="@lang('image')">
                    <p>@lang('No game available in this category')</p>

                </div>
            @endif
        </div>
    </div>
@endsection

@push('script')
    <script>
        (function($) {
            "use strict";

            $(".banner-slider").stepCycle({
                autoAdvance: true,
                transitionTime: 1,
                displayTime: 5,
                transition: "zoomIn",
                easing: "linear",
                childSelector: false,
                ie8CheckSelector: ".ltie9",
                showNav: false,
                transitionBegin: function() {},
                transitionComplete: function() {},
            });

            function controlSliderHeight() {
                let width = $(".banner-slider")[0].clientWidth;
                let height = (width / 37) * 7;
                $(".banner-slider").css({
                    height: height,
                });

                $(".banner_image").css({
                    height: height,
                });
            }

            controlSliderHeight();


            $('.custom-dropdown-selected').click(function() {
                $(this).parents('.custom-dropdown').toggleClass('show');
            });

            $(window).scroll(function() {
                $('.custom-dropdown.show').toggleClass('show');
            });

            $('.custom-dropdown').mouseleave(function() {
                $(this).removeClass('show');
            });

            $('.custom-dropdown-list-item').on('click', function() {
                let parent = $(this).parents('.custom-dropdown');
                let selected = parent.find('.custom-dropdown-selected');
                parent.find('.custom-dropdown-list-item.disabled').removeClass('disabled');
                $(this).addClass('disabled');
                $(selected).text($(this).text());
                parent.removeClass('show');

                getOdds($(this).data('reference'), function(data) {
                    parent.siblings('.option-odd-lists').slick('unslick');
                    parent.siblings('.option-odd-lists').html(data);
                    initOddsSlider(parent.siblings('.option-odd-lists'));
                });

            });

            function getOdds(id, callback) {
                $.get(`{{ route('market.odds', '') }}/${id}`,
                    function(data) {
                        callback(data);
                    }
                );
            }

        })(jQuery);
    </script>
@endpush
