<?php $__env->startSection('master'); ?>
    <div class="d-flex justify-content-between align-items-center mt-0 flex-wrap gap-3 pb-3">
        <div class="action-area d-flex flex-wrap gap-2">
            <a class="btn btn-outline--base btn-sm <?php if(!request()->type): ?> active <?php endif; ?>" href="<?php echo e(route('user.bets')); ?>"><?php echo app('translator')->get('All'); ?></a>
            <a class="btn btn-outline--base btn-sm <?php if(request()->type == 'pending'): ?> active <?php endif; ?>" href="<?php echo e(route('user.bets', 'pending')); ?>"><?php echo app('translator')->get('Pending'); ?></a>
            <a class="btn btn-outline--base btn-sm <?php if(request()->type == 'win'): ?> active <?php endif; ?>" href="<?php echo e(route('user.bets', 'win')); ?>"><?php echo app('translator')->get('Win'); ?></a>
            <a class="btn btn-outline--base btn-sm <?php if(request()->type == 'lose'): ?> active <?php endif; ?>" href="<?php echo e(route('user.bets', 'lose')); ?>"><?php echo app('translator')->get('Lose'); ?></a>
            <a class="btn btn-outline--base btn-sm <?php if(request()->type == 'refunded'): ?> active <?php endif; ?>" href="<?php echo e(route('user.bets', 'refunded')); ?>"><?php echo app('translator')->get('Refunded'); ?></a>
        </div>
        <form>
            <div class="input-group">
                <input class="form-control form--control" name="search" type="text" value="<?php echo e(request()->search); ?>" placeholder="<?php echo app('translator')->get('Search by bet number'); ?>">
                <button class="input-group-text bg--base text-white"><i class="las la-search"></i></button>
            </div>
        </form>
    </div>
    <div class="bet-table">
        <table class="table-responsive--md custom--table custom--table-separate table">
            <thead>
                <tr>
                    <th><?php echo app('translator')->get('Bet No.'); ?></th>
                    <th><?php echo app('translator')->get('Type'); ?></th>
                    <th><?php echo app('translator')->get('Bet Count'); ?></th>
                    <th><?php echo app('translator')->get('Invested'); ?></th>
                    <th><?php echo app('translator')->get('Return'); ?></th>
                    <th><?php echo app('translator')->get('Status'); ?></th>
                    <th><?php echo app('translator')->get('Details'); ?></th>
                </tr>
            </thead>

            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $bets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bet): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td><span class="fw-bold"><?php echo e(__($bet->bet_number)); ?></span> </td>
                        <td>
                            <?php echo $bet->betTypeBadge ?>
                        </td>
                        <td> <?php echo e($bet->bets->count()); ?> </td>
                        <td> <?php echo e(showAmount($bet->stake_amount)); ?> </td>
                        <td> <?php echo e(showAmount($bet->return_amount)); ?> </td>
                        <td>
                            <?php if($bet->amount_returned): ?>
                                <span class="badge badge--warning"><?php echo app('translator')->get('Pending'); ?></span>
                            <?php else: ?>
                                <?php echo $bet->betStatusBadge ?>
                            <?php endif; ?>
                        </td>
                        <td>
                            <button class="btn btn--view view-btn" data-amount_returned="<?php echo e($bet->amount_returned); ?>" data-bet_details='<?php echo e($bet->bets); ?>' type="button">
                                <i class="las la-desktop"></i>
                            </button>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td class="text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <div class="mt-4 align-items-center pagination-wrapper">
        <?php echo e($bets->links()); ?>

    </div>

    <div class="modal fade" id="betDetailModal" role="dialog" aria-labelledby="modalTitleId" aria-hidden="true" tabindex="-1">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="m-0"><?php echo app('translator')->get('Bet Detail'); ?></h5>
                    <span class="close" data-bs-dismiss="modal" type="button" aria-label="Close">
                        <i class="las la-times"></i>
                    </span>
                </div>
                <div class="modal-body">
                    <table class="table-responsive--md custom--table custom--table-separate table">
                        <thead>
                            <tr>
                                <th><?php echo app('translator')->get('Game'); ?></th>
                                <th><?php echo app('translator')->get('Market'); ?></th>
                                <th><?php echo app('translator')->get('Option'); ?></th>
                                <th><?php echo app('translator')->get('Status'); ?></th>
                            </tr>
                        </thead>
                        <tbody></tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";
            $('.view-btn').on('click', function(e) {
                var modal = $('#betDetailModal');
                modal.find('tbody').html('');
                var betDetails = $(this).data('bet_details');
                var betStatus = $(this).data('amount_returned');
                var tableRow = ``;
                $.each(betDetails, function(index, detail) {
                    var status = ``;
                    if (betStatus) {
                        status = `<span class="badge badge--warning"><?php echo app('translator')->get('Pending'); ?></span>`
                    } else {
                        if (detail.status == 1) {
                            status = `<span class="badge badge--success"><?php echo app('translator')->get('Won'); ?></span>`
                        } else if (detail.status == 2) {
                            status = `<span class="badge badge--warning"><?php echo app('translator')->get('Pending'); ?></span>`
                        } else if (detail.status == 3) {
                            status = `<span class="badge badge--danger"><?php echo app('translator')->get('Lose'); ?></span>`
                        } else if (detail.status == 4) {
                            status = `<span class="badge badge--info"><?php echo app('translator')->get('Refund'); ?></span>`
                        }
                    }
                    tableRow += `<tr>
                                    <td data-label="<?php echo app('translator')->get('Game'); ?>">
                                        ${detail.option.question.game.team_one.short_name}
                                        <span class="text--base px-1"><?php echo app('translator')->get('vs'); ?></span>
                                        ${detail.option.question.game.team_two.short_name}
                                    </td>
                                    <td data-label="<?php echo app('translator')->get('Market'); ?>">${detail.option.question.title}</td>
                                    <td data-label="<?php echo app('translator')->get('Option'); ?>">${detail.option.name}</td>
                                    <td data-label="<?php echo app('translator')->get('Status'); ?>">
                                        ${status}
                                    </td>
                                </tr>`
                });
                modal.find('tbody').html(tableRow);
                modal.modal('show');
            });
        })(jQuery)
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\Laravel\bet\core\resources\views/templates/basic/user/bet/index.blade.php ENDPATH**/ ?>