@extends($activeTemplate . 'layouts.bet')
@section('bet')
    @php
        $banners = getContent('banner.element', false, null, true);
        $optionsId = collect(session()->get('bets'))->pluck('option_id')->toArray();
    @endphp

    <div class="col-12">
        <div class="banner-slider hero-slider mb-3">
            @foreach ($banners as $banner)
                <div class="banner_slide">
                    <img class="banner_image" src="{{ frontendImage('banner', @$banner->data_values->image, '1610x250') }}">
                </div>
            @endforeach
        </div>
    </div>
    {{-- <div class="col-12">
        <div class="banner-slider hero-slider mb-3">
            @foreach ($banners as $banner)
                <div class="banner_slide">
                    <img class="banner_image" src="{{ frontendImage('banner', @$banner->data_values->image, '1610x250') }}">
                </div>
            @endforeach
        </div>
    </div> --}}

    <div class="col-12" id="{{ count($games) }}">
        <div class="betting-body">
            <div class="grid-line">
                {{-- @foreach ($games as $game) --}}
                {{-- <div class="grid-line__title">
                    <a href="/football" class="grid-line__title-link">
                        <div class="grid-line__title-icon">
                            <i class="discipline-icon _football"></i>
                        </div>
                        <div class="grid-line__title-container">
                            <div class="grid-line__title-main">
                                <span>Football</span>
                            </div>
                        </div>
                    </a>
                    <div class="grid-markets-filter dropdown">
                        <div class="grid-markets-filter__title dropdown__head">
                            <span>Match Winner</span>
                            <i class="iconFont iconFont-icon-arrow-right-pro"></i>
                        </div>
                        <div class="grid-markets-filter__holder dropdown__holder">
                            <div class="grid-markets-filter__content dropdown__container">
                                <div class="grid-markets-filter__item" role="button">Handicap</div>
                                <div class="grid-markets-filter__item" role="button">Total</div>
                                <div class="grid-markets-filter__item" role="button">Double Chances</div>
                                <div class="grid-markets-filter__item" role="button">Asian handicap</div>
                                <div class="grid-markets-filter__item" role="button">Asian total</div>
                            </div>
                        </div>
                    </div>
                    <div class="filter-sorting--portal"></div>
                </div>
                <div class="grid-line__content">
                    <div class="grid-event _with-video _no-video grid-event-pro" role="presentation">
                        <div class="grid-event__title _football">
                            <div class="grid-event__tournament">
                                <div class="tournament-logo">
                                    <img title="Germany. Bundesliga" alt="Germany. Bundesliga" class="logo-img"
                                        src="https://prod.sportbook.work/icons/tournament/30/26.png">
                                </div>
                                <a href="javascript:void(0);" class="grid-event__tournament-name hover-underline">
                                    Germany. Bundesliga</a>
                                <span class="hot-badge"></span>
                            </div>
                            <div class="grid-event-pro__title">
                                <div class="grid-event__time">
                                    <span>Sep 14 • 00:00</span>
                                </div>
                                <div class="_title-icons__wrap">
                                    <i class="iconFont iconFont-icon-match-tracker-pro"></i>
                                </div>
                            </div>
                        </div>
                        <div class="grid-event__content">
                            <a href="/football/borussia-dortmund-vs-1-fc-heidenheim-21026945/bets"
                                class="grid-event__competitors">
                                <div class="grid-event__competitors-wrapper">
                                    <div class="grid-event__competitor">
                                        <img alt="Borussia Dortmund-logo" src="https://prod.sportbook.work/icons/30/74.png"
                                            data-src="https://prod.sportbook.work/icons/30/74.png" width="30"
                                            height="30" class="grid-event__competitor-logo lazyloaded">
                                        <div class="grid-event__competitor-wrap">
                                            <div class="grid-event__competitor-name">
                                                <span>Borussia
                                                    Dortmund</span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="grid-event__competitors-divider">
                                        VS</div>
                                    <div class="grid-event__competitor">
                                        <img alt="1 FC Heidenheim-logo" src="https://prod.sportbook.work/icons/30/234.png"
                                            data-src="https://prod.sportbook.work/icons/30/234.png" width="30"
                                            height="30" class="grid-event__competitor-logo ls-is-cached lazyloaded">
                                        <div class="grid-event__competitor-wrap">
                                            <div class="grid-event__competitor-name">
                                                <span>1 FC Heidenheim</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </a>
                            <div class="grid-markets">
                                <div class="grid-market _multi">
                                    <button class="outcome equal _101" type="button" data-result-status=""
                                        style="order: 101;">
                                        <span class="outcome__status">1</span>
                                        <span class="outcome__number">1.36</span>
                                    </button>
                                    <button class="outcome equal _102" type="button" data-result-status=""
                                        style="order: 102;">
                                        <span class="outcome__status">X</span>
                                        <span class="outcome__number">5.50</span>
                                    </button>
                                    <button class="outcome equal _103" type="button" data-result-status=""
                                        style="order: 103;">
                                        <span class="outcome__status">2</span>
                                        <span class="outcome__number">7.60</span>
                                    </button>
                                </div>
                                <div class="grid-market__name" style="order: 1;">Match Winner</div>
                                <a href="/football/borussia-dortmund-vs-1-fc-heidenheim-21026945/bets"
                                    class="grid-event-pro__totals">+176</a>
                            </div>
                        </div>
                    </div>
                    <div class="grid-event _with-video _no-video grid-event-pro" role="presentation">
                        <div class="grid-event__title _football">
                            <div class="grid-event__tournament">
                                <div class="tournament-logo">
                                    <img title="Championship of Indonesia. ISC A" alt="Championship of Indonesia. ISC A"
                                        class="logo-img" src="https://prod.sportbook.work/icons/tournament/30/303.png">
                                </div>
                                <a href="javascript:void(0);" class="grid-event__tournament-name hover-underline">
                                    Championship of Indonesia. ISC A</a>
                            </div>
                            <div class="grid-event-pro__title">
                                <div class="grid-event__time">
                                    <span>
                                        <span class="title">Live
                                            in:</span>
                                        <span class="time"> 22m</span>
                                    </span>
                                </div>
                                <div class="_title-icons__wrap">
                                    <i class="iconFont iconFont-icon-match-tracker-pro"></i>
                                </div>
                            </div>
                        </div>
                        <div class="grid-event__content">
                            <a href="/football/sleman-vs-pusamania-borneo-21478595/bets" class="grid-event__competitors">
                                <div class="grid-event__competitors-wrapper">
                                    <div class="grid-event__competitor">
                                        <img alt="Sleman-logo" src="https://prod.sportbook.work/icons/30/11868.png"
                                            data-src="https://prod.sportbook.work/icons/30/11868.png" width="30"
                                            height="30" class="grid-event__competitor-logo lazyloaded">
                                        <div class="grid-event__competitor-wrap">
                                            <div class="grid-event__competitor-name">
                                                <span>Sleman</span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="grid-event__competitors-divider">
                                        VS</div>
                                    <div class="grid-event__competitor">
                                        <img alt="Pusamania Borneo-logo"
                                            src="https://prod.sportbook.work/icons/30/2414.png"
                                            data-src="https://prod.sportbook.work/icons/30/2414.png" width="30"
                                            height="30" class="grid-event__competitor-logo lazyloaded">
                                        <div class="grid-event__competitor-wrap">
                                            <div class="grid-event__competitor-name">
                                                <span>Pusamania
                                                    Borneo</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </a>
                            <div class="grid-markets">
                                <div class="grid-market _multi">
                                    <button class="outcome equal _101" type="button" data-result-status=""
                                        style="order: 101;">
                                        <span class="outcome__status">1</span>
                                        <span class="outcome__number">4.20</span>
                                    </button>
                                    <button class="outcome equal _102" type="button" data-result-status=""
                                        style="order: 102;">
                                        <span class="outcome__status">X</span>
                                        <span class="outcome__number">3.27</span>
                                    </button>
                                    <button class="outcome equal _103" type="button" data-result-status=""
                                        style="order: 103;">
                                        <span class="outcome__status">2</span>
                                        <span class="outcome__number">1.76</span>
                                    </button>
                                </div>
                                <div class="grid-market__name" style="order: 1;">Match Winner</div>
                                <a href="/football/sleman-vs-pusamania-borneo-21478595/bets"
                                    class="grid-event-pro__totals">+47</a>
                            </div>
                        </div>
                    </div>
                    <div class="grid-event _with-video _no-video grid-event-pro" role="presentation">
                        <div class="grid-event__title _football">
                            <div class="grid-event__tournament">
                                <div class="tournament-logo">
                                    <img title="Championship of Thailand. Premier League"
                                        alt="Championship of Thailand. Premier League" class="logo-img"
                                        src="https://prod.sportbook.work/icons/tournament/30/343.png">
                                </div>
                                <a href="javascript:void(0);" class="grid-event__tournament-name hover-underline">
                                    Championship of Thailand. Premier
                                    League</a>
                            </div>
                            <div class="grid-event-pro__title">
                                <div class="grid-event__time">
                                    <span>Sep 12 • 17:00</span>
                                </div>
                                <div class="_title-icons__wrap">
                                    <i class="iconFont iconFont-icon-match-tracker-pro"></i>
                                </div>
                            </div>
                        </div>
                        <div class="grid-event__content">
                            <a href="/football/fc-port-vs-buriram-united-21720555/bets" class="grid-event__competitors">
                                <div class="grid-event__competitors-wrapper">
                                    <div class="grid-event__competitor">
                                        <img alt="FC Port-logo" src="https://prod.sportbook.work/icons/30/9554.png"
                                            data-src="https://prod.sportbook.work/icons/30/9554.png" width="30"
                                            height="30" class="grid-event__competitor-logo lazyloaded">
                                        <div class="grid-event__competitor-wrap">
                                            <div class="grid-event__competitor-name">
                                                <span>FC Port</span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="grid-event__competitors-divider">
                                        VS</div>
                                    <div class="grid-event__competitor">
                                        <img alt="Buriram United-logo" src="https://prod.sportbook.work/icons/30/3110.png"
                                            data-src="https://prod.sportbook.work/icons/30/3110.png" width="30"
                                            height="30" class="grid-event__competitor-logo lazyloaded">
                                        <div class="grid-event__competitor-wrap">
                                            <div class="grid-event__competitor-name">
                                                <span>Buriram United</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </a>
                            <div class="grid-markets">
                                <div class="grid-market _multi">
                                    <button class="outcome equal _101" type="button" data-result-status=""
                                        style="order: 101;">
                                        <span class="outcome__status">1</span>
                                        <span class="outcome__number">3.25</span>
                                    </button>
                                    <button class="outcome equal _102" type="button" data-result-status=""
                                        style="order: 102;">
                                        <span class="outcome__status">X</span>
                                        <span class="outcome__number">3.90</span>
                                    </button><button class="outcome equal _103" type="button" data-result-status=""
                                        style="order: 103;">
                                        <span class="outcome__status">2</span>
                                        <span class="outcome__number">1.93</span>
                                    </button>
                                </div>
                                <div class="grid-market__name" style="order: 1;">Match Winner</div>
                                <a href="/football/fc-port-vs-buriram-united-21720555/bets"
                                    class="grid-event-pro__totals">+47</a>
                            </div>
                        </div>
                    </div>
                </div> --}}
                {{-- @endforeach --}}
            </div>
            <div class="row g-3">
                {{-- @if (@$activeLeague && $games->count()) --}}
                {{-- @foreach ($activeLeague as $cat)
                    <div class="col-12">
                        <div class="league-title">
                            <span class="league-title__flag">
                                <img class="league-title__flag-img"
                                    src="{{ getImage(getFilePath('league') . '/' . @$cat->image, getFileSize('league')) }}"
                                    alt="@lang('image')">
                            </span>
                            <span class="league-title__name" style="color: white">
                                {{ __(@$cat->name) }}
                            </span>
                        </div>
                    </div>
                @endforeach --}}
                {{-- <div class="col-12">
                        <div class="league-title">
                            <span class="league-title__flag">
                                <img class="league-title__flag-img"
                                    src="{{ getImage(getFilePath('league') . '/' . @$activeLeague->image, getFileSize('league')) }}"
                                    alt="@lang('image')">
                            </span>
                            <span class="league-title__name" style="color: white">
                                {{ __(@$activeLeague->name) }}
                            </span>
                        </div>
                    </div> --}}
                {{-- @endif --}}
                @foreach ($leagues as $league)
                    @if ($league[0]->games->count() > 0)
                        @foreach ($league[0]->games as $game)
                            <div class="grid-line__title">
                                <a href="{{ route('category.games', @$league[0]->category->slug) }}"
                                    class="grid-line__title-link">
                                    <div class="grid-line__title-icon">
                                        <i class="discipline-icon _football"></i>
                                    </div>
                                    <div class="grid-line__title-container">
                                        <div class="grid-line__title-main">
                                            <span>{{ __(@$league[0]->category->name) }}</span>
                                        </div>
                                    </div>
                                </a>
                                {{-- <div class="grid-markets-filter dropdown">
                                    <div class="grid-markets-filter__title dropdown__head">
                                        <span>Match Winner</span>
                                        <i class="iconFont iconFont-icon-arrow-right-pro"></i>
                                    </div>
                                    <div class="grid-markets-filter__holder dropdown__holder">
                                        <div class="grid-markets-filter__content dropdown__container">
                                            <div class="grid-markets-filter__item" role="button">Handicap</div>
                                            <div class="grid-markets-filter__item" role="button">Total</div>
                                            <div class="grid-markets-filter__item" role="button">Double Chances</div>
                                            <div class="grid-markets-filter__item" role="button">Asian handicap</div>
                                            <div class="grid-markets-filter__item" role="button">Asian total</div>
                                        </div>
                                    </div>
                                </div> --}}
                                {{-- <div class="filter-sorting--portal"></div> --}}
                            </div>
                            <div class="grid-line__content">
                                <div class="grid-event _with-video _no-video grid-event-pro" role="presentation">
                                    <div class="grid-event__title _football">
                                        <div class="grid-event__tournament">
                                            <div class="tournament-logo">
                                                <img class="logo-img"
                                                    src="{{ getImage(getFilePath('league') . '/' . @$league[0]->image, getFileSize('league')) }}"
                                                    alt="@lang('image')">
                                            </div>
                                            <a href="javascript:void(0);"
                                                class="grid-event__tournament-name hover-underline">
                                                {{ @$league[0]->name }} </a>
                                            <span class="hot-badge"></span>
                                        </div>
                                        <div class="grid-event-pro__title">
                                            <div class="grid-event__time">
                                                <span>{{ $game->bet_start_time }}</span>
                                            </div>
                                            @if ($game->isRunning)
                                                <div class="_title-icons__wrap">
                                                    <i class="iconFont iconFont-icon-match-tracker-pro"
                                                        style="color: red"></i>
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                    <div class="grid-event__content">
                                        <a href=#" class="grid-event__competitors">
                                            <div class="grid-event__competitors-wrapper">
                                                <div class="grid-event__competitor">
                                                    <img src="{{ $game->teamOne->teamImage() }}" alt="@lang('image')"
                                                        width="30" height="30"
                                                        class="grid-event__competitor-logo lazyloaded">
                                                    <div class="grid-event__competitor-wrap">
                                                        <div class="grid-event__competitor-name">
                                                            <span>{{ __($game->teamOne->short_name) }}</span>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="grid-event__competitors-divider">
                                                    VS</div>
                                                <div class="grid-event__competitor">
                                                    <img src="{{ $game->teamTwo->teamImage() }}" alt="@lang('image')"
                                                        width="30" height="30"
                                                        class="grid-event__competitor-logo ls-is-cached lazyloaded">
                                                    <div class="grid-event__competitor-wrap">
                                                        <div class="grid-event__competitor-name">
                                                            <span>{{ __($game->teamTwo->short_name) }}</span>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </a>
                                        @if ($game->questions->count())
                                            @php
                                                $firstMarket = $game->questions->first();
                                                $showCount = 3;
                                                $more = $game->questions->count() - $showCount;
                                                if ($more <= 0) {
                                                    $more = 'More..';
                                                }
                                                $i = 1;
                                            @endphp
                                            <div class="grid-markets">
                                                <div class="grid-market _multi option-odd-lists">
                                                    @foreach ($firstMarket->options as $option)
                                                        @if ($i == 4)
                                                            @continue
                                                        @endif
                                                        <div class="option-odd-list__item">
                                                            <button
                                                                class="outcome equal _101 oddBtn @if (in_array($option->id, $optionsId)) active @endif @if ($option->locked) locked @endif"
                                                                data-option_id="{{ $option->id }}"
                                                                @disabled($game->bet_start_time >= now())
                                                                style="order: 10{{ $i }};">
                                                                <span class="outcome__status">{{ $option->name }}</span>
                                                                <span
                                                                    class="outcome__number">{{ rateData($option->odds) }}</span>
                                                            </button>
                                                            @php
                                                                $i++;
                                                            @endphp

                                                        </div>
                                                        {{-- <button class="outcome equal _102" type="button" data-result-status=""
                                                        style="order: 102;">
                                                        <span class="outcome__status">X</span>
                                                        <span class="outcome__number">5.50</span>
                                                    </button>
                                                    <button class="outcome equal _103" type="button" data-result-status=""
                                                        style="order: 103;">
                                                        <span class="outcome__status">2</span>
                                                        <span class="outcome__number">7.60</span>
                                                    </button> --}}
                                                    @endforeach
                                                </div>
                                                {{-- <div class="grid-market__name" style="order: 1;">Match Winner</div> --}}
                                                <a href="{{ route('game.markets', $game->slug) }}"
                                                    class="grid-event-pro__totals">{{ $more }}</a>
                                            </div>
                                        @endif
                                    </div>
                                </div>
                            </div>




                            {{-- <div class="col-sm-6 col-lg-6 col-md-4 col-xl-4 col-xxl-3 col-msm-6">
                                <div class="sports-card position-relative">
                                    <span class="sports-card__head">
                                        <span class="sports-card__team">
                                            <span class="sports-card__team-flag">
                                                <img class="sports-card__team-flag-img"
                                                    src="{{ $game->teamOne->teamImage() }}" alt="@lang('image')">
                                            </span>
                                            <span class="sports-card__team-name">
                                                {{ __($game->teamOne->short_name) }}
                                            </span>
                                        </span>
                                        @if ($game->isRunning)
                                            <span class="sports-card__info text-center">
                                                <span class="sports-card__stream">
                                                    <i class="fa-regular fa-circle-play text--danger"></i>
                                                </span>
                                                <span class="sports-card__info-text">@lang('Live Now')</span>
                                            </span>
                                        @else
                                            <span class="sports-card__info text-center">
                                                <span class="sports-card__stream">
                                                    <i class="fa-regular fa-circle-play"></i>
                                                </span>

                                                <span class="sports-card__info-text">@lang('Starts On')</span>
                                                <span
                                                    class="sports-card__info-time">{{ carbonParse($game->bet_start_time, 'd M, h:i') }}</span>
                                            </span>
                                        @endif

                                        <span class="sports-card__team">
                                            <span class="sports-card__team-flag">
                                                <img class="sports-card__team-flag-img"
                                                    src="{{ $game->teamTwo->teamImage() }}" alt="@lang('image')">
                                            </span>
                                            <span class="sports-card__team-name">
                                                {{ __($game->teamTwo->short_name) }}
                                            </span>
                                        </span>
                                    </span>
                                    @if ($game->questions->count())
                                        @php
                                            $firstMarket = $game->questions->first();
                                            $showCount = 4;
                                            $more = $game->questions->count() - $showCount;
                                        @endphp

                                        <div class="custom-dropdown">
                                            <div class="d-flex justify-content-between">
                                                <span class="custom-dropdown-selected">{{ $firstMarket->title }}</span>
                                                <a href="{{ route('game.markets', $game->slug) }}"
                                                    class="text--small">@lang('Markets')</a>
                                            </div>

                                            <div class="custom-dropdown-list">
                                                @foreach ($game->questions->take($showCount) as $question)
                                                    <div class="custom-dropdown-list-item @if ($firstMarket->id == $question->id) disabled @endif @if ($question->locked) locked @endif"
                                                        data-reference="{{ $question->id }}">{{ $question->title }}</div>
                                                @endforeach

                                                @if ($more > 0)
                                                    <div class="text-center mt-1">
                                                        <a href="{{ route('game.markets', $game->slug) }}?more={{ $more }}"
                                                            class="text--small"> +{{ $more }}
                                                            @lang('More')</a>
                                                    </div>
                                                @endif
                                            </div>
                                        </div>

                                        <div class="option-odd-list">
                                            @foreach ($firstMarket->options as $option)
                                                <div class="option-odd-list__item">
                                                    <div>
                                                        <button
                                                            class="btn btn-sm btn-light text--small border oddBtn @if (in_array($option->id, $optionsId)) active @endif @if ($option->locked) locked @endif"
                                                            data-option_id="{{ $option->id }}"
                                                            @disabled($game->bet_start_time >= now())>{{ rateData($option->odds) }}
                                                        </button>
                                                        <span
                                                            class="text--extra-small d-block text-center">{{ $option->name }}</span>
                                                    </div>
                                                </div>
                                            @endforeach
                                        </div>
                                    @endif
                                </div>
                            </div> --}}
                        @endforeach
                    @endif
                @endforeach
            </div>
            @if (blank($games))
                <div class="empty-message mt-3">
                    <img class="img-fluid" src="{{ asset($activeTemplateTrue . 'images/empty_message.png') }}"
                        alt="@lang('image')">
                    <p>@lang('No game available in this category')</p>

                </div>
            @endif
        </div>
    </div>
@endsection

@push('script')
    <script>
        (function($) {
            "use strict";

            $(".banner-slider").stepCycle({
                autoAdvance: true,
                transitionTime: 1,
                displayTime: 5,
                transition: "zoomIn",
                easing: "linear",
                childSelector: false,
                ie8CheckSelector: ".ltie9",
                showNav: false,
                transitionBegin: function() {},
                transitionComplete: function() {},
            });

            function controlSliderHeight() {
                let width = $(".banner-slider")[0].clientWidth;
                let height = (width / 37) * 7;
                $(".banner-slider").css({
                    height: height,
                });

                $(".banner_image").css({
                    height: height,
                });
            }

            controlSliderHeight();


            $('.custom-dropdown-selected').click(function() {
                $(this).parents('.custom-dropdown').toggleClass('show');
            });

            $(window).scroll(function() {
                $('.custom-dropdown.show').toggleClass('show');
            });

            $('.custom-dropdown').mouseleave(function() {
                $(this).removeClass('show');
            });

            $('.custom-dropdown-list-item').on('click', function() {
                let parent = $(this).parents('.custom-dropdown');
                let selected = parent.find('.custom-dropdown-selected');
                parent.find('.custom-dropdown-list-item.disabled').removeClass('disabled');
                $(this).addClass('disabled');
                $(selected).text($(this).text());
                parent.removeClass('show');

                getOdds($(this).data('reference'), function(data) {
                    parent.siblings('.option-odd-lists').slick('unslick');
                    parent.siblings('.option-odd-lists').html(data);
                    initOddsSlider(parent.siblings('.option-odd-lists'));
                });

            });

            function getOdds(id, callback) {
                $.get(`{{ route('market.odds', '') }}/${id}`,
                    function(data) {
                        callback(data);
                    }
                );
            }

        })(jQuery);
    </script>
@endpush
