<!doctype html>
<html lang="{{ config('app.locale') }}" itemscope itemtype="http://schema.org/WebPage">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title> {{ gs()->siteName(__($pageTitle)) }}</title>
    @include('partials.seo')
	<!--
    <link href="{{ asset('assets/global/css/bootstrap.min.css') }}" rel="stylesheet">
    <link href="{{ asset('assets/global/css/all.min.css') }}" rel="stylesheet">
    <link rel="stylesheet" href="{{ asset('assets/global/css/line-awesome.min.css') }}">
	<link rel="icon" type="image/x-icon" href="images/fav_icon.png">
	-->
	  <link rel="icon" type="image/x-icon" href="{{ asset($activeTemplateTrue . 'betnew/images/fav_icon.png') }}">
	  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
      <link href="{{ asset($activeTemplateTrue . 'betnew/css/style.css') }}" rel="stylesheet">
      <link href="{{ asset($activeTemplateTrue . 'betnew/css/media.css') }}" rel="stylesheet">
	  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css" rel="stylesheet">
	  <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
	  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
	  <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.8/dist/umd/popper.min.js"></script>
	  
	  <link rel="preconnect" href="https://fonts.googleapis.com">
	  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
	  <link href="https://fonts.googleapis.com/css2?family=Montez&family=Rubik:ital,wght@0,300..900;1,300..900&display=swap" rel="stylesheet">

	  
	  
	    <!-- owl carousel -->

	 <link href="{{ asset($activeTemplateTrue . 'betnew/css/owl-carousel/owl.carousel.css') }}" rel="stylesheet">
	
    <script src="{{ asset($activeTemplateTrue . 'betnew/js/owl-carousel/owl.carousel.js') }}"></script>

	
  
   <style>   
   .preloader__img {
    display: none;
    } 
   </style>
   
    
</head>
@php echo loadExtension('google-analytics') @endphp

<body>
    <div class="preloader">
        <div class="preloader__img">
            <img src="{{ siteFavicon() }}" alt="@lang('image')" />
        </div>
    </div>

    <div class="back-to-top">
        <span class="back-top">
            <i class="las la-angle-double-up"></i>
        </span>
    </div>

    <div class="body-overlay" id="body-overlay"></div>
    <div class="header-overlay"></div>
    <div class="common_themev2Sport__sVnK">
        <div id="app" class="turbo_sportsbook pro_layout"
            style="--bg-competitor1: #35FF97; --text-competitor1: #35FF97; --bg-competitor2: #489EFF; --text-competitor2: #489EFF; --bg-main-lighter: rgba(255, 255, 255, 0.2); --text-default: #8E949F; --text-lighter: #ffffff; --text-highlighted: #ffffff; --text-active: #FB8C32; --body-main: #11141C; --active-dark: #262B3B; --text-inverted: unset; --bg-main-light: unset; --bg-main-elements: #282F3E; --bg-main-layouts: #1C212B; --bg-main-body: #0D141C; --bg-light-grey: #32374A; --bg-active: #006AE5; --bg-main-elements-active: unset; --bg-panel: unset; --bg-alert-regular: unset; --red-bg-color: #ff3535; --borders-main: unset; --bg-error: unset; --event-header-gradient-right: unset; --event-header-gradient-left: unset; --live-event-header-gradient-right: unset; --live-event-header-gradient-left: unset; --slider-gradient-top: unset; --slider-gradient-bottom: unset; --slider-control: unset; --combo-booster-filler: #57585e; --combo-booster-filler-border: #757c80; --mobile-menu-top: #2f343c; --mobile-menu-bottom: #212429; --default-border-radius: 12px; --bg-active-gradient: linear-gradient(225deg, #FFC12E 36.46%, #FF4547 100%); --bg-active-lobby-filters: rgba(251, 140, 50, 0.06); --bg-icon-all-countries: linear-gradient(135deg, #3FF487 0%, #192EF1 100%); --bg-mobile-menu-head: #DCDEE4; --color-pink: #EC4997; --color-yellow: #FFC12E; --color-red: #E5063E; --red: #E5063E; --color-blue: #2188FF; --color-green: #00A828; --green: #00A828; --color-gray-600: #4F5664; --borders-color: #3D4451; --border-radius-outer: 6px; --border-radius-inner: 3px; --border-radius-lobby-filters: 18px; --shadow-nav-button: linear-gradient(90deg, rgba(28, 33, 43, 0.00) 0%, #1C212B 100%); --shadow-nav-button-main-page: linear-gradient(90deg, rgba(17, 20, 28, 0.00) 0%, #11141C 100%);  background: var(--body-main)">
            @yield('content')

        </div>
    </div>

    @php
        $cookie = App\Models\Frontend::where('data_keys', 'cookie.data')->first();
    @endphp
    @if ($cookie->data_values->status == Status::ENABLE && !\Cookie::get('gdpr_cookie'))
        <div class="cookies-card text-center hide">
            <div class="cookies-card__icon bg--base">
                <i class="las la-cookie-bite"></i>
            </div>
            <p class="mt-4 cookies-card__content">{{ $cookie->data_values->short_desc }} <a
                    href="{{ route('cookie.policy') }}" target="_blank">@lang('learn more')</a></p>
            <div class="cookies-card__btn mt-4">
                <a href="javascript:void(0)" class="btn btn--xl btn--base w-100 policy">@lang('Allow')</a>
            </div>
        </div>
    @endif

  
    @stack('script-lib')

    @php echo loadExtension('tawk-chat') @endphp

    @include('partials.notify')

    @if (gs('pn'))
        @include('partials.push_script')
    @endif


    @stack('script')

    <script>
        (function($) {
            "use strict";
            $(".langSel").on("click", function() {
                window.location.href = "{{ route('home') }}/change/" + $(this).data('code');
            });

            $(".oddsType").on("change", function() {
                window.location.href = `{{ route('odds.type', '') }}/${$(this).val()}`;
            });

            $('.policy').on('click', function() {
                $.get('{{ route('cookie.accept') }}', function(response) {
                    $('.cookies-card').addClass('d-none');
                });
            });

            setTimeout(function() {
                $('.cookies-card').removeClass('hide')
            }, 2000);

            var inputElements = $('[type=text],select,textarea');
            $.each(inputElements, function(index, element) {
                element = $(element);
                element.closest('.form-group').find('label').attr('for', element.attr('name'));
                element.attr('id', element.attr('name'))
            });

            $.each($('input, select, textarea'), function(i, element) {
                var elementType = $(element);
                if (elementType.attr('type') != 'checkbox') {
                    if (element.hasAttribute('required')) {
                        $(element).closest('.form-group').find('label').addClass('required');
                    }
                }

            });
            let disableSubmission = false;
            $('.disableSubmission').on('submit', function(e) {
                if (disableSubmission) {
                    e.preventDefault()
                } else {
                    disableSubmission = true;
                }
            });

            $.each($(".select2"), function() {
                $(this)
                    .wrap(`<div class="position-relative"></div>`)
                    .select2({
                        dropdownParent: $(this).parent(),
                    });
            });


            Array.from(document.querySelectorAll('table')).forEach(table => {
                let heading = table.querySelectorAll('thead tr th');
                Array.from(table.querySelectorAll('tbody tr')).forEach(row => {
                    Array.from(row.querySelectorAll('td')).forEach((column, i) => {
                        (column.colSpan == 100) || column.setAttribute('data-label', heading[i]
                            .innerText)
                    });
                });
            });
        })(jQuery);
    </script>
    <script>
        <!-- Init first dataLayer data
        -->
        const
        url
        =
        new
        URL(window.location.href);
        url.searchParams.delete("token");
        const
        ls
        =
        localStorage
        ||
        {
        getItem:
        ()
        =>
        null
        },
        cid
        =
        url.searchParams.get("cid")
        ||
        ls.getItem("brand"),
        subPartnerId
        =
        url.searchParams.get("sub_partner_id")
        ||
        ls.getItem("subPartnerId"),
        theme
        =
        url.searchParams.get("theme")
        ||
        ls.getItem("color_theme"),
        lang
        =
        url.searchParams.get("locale")
        ||
        ls.getItem("locale");
        window.dataLayer
        =
        [{
        event:
        "ga4_interaction",
        action:
        "init",
        cid,
        subpartner_id:
        subPartnerId,
        theme,
        lang,
        safe_url:
        url.href
        }];
    </script>
    <script>
        (function(w, d, s, l, i) {
            w[l] = w[l] || [];
            w[l].push({
                'gtm.start': new Date().getTime(),
                event: 'gtm.js'
            });
            var f = d.getElementsByTagName(s)[0],
                j = d.createElement(s),
                dl = l != 'dataLayer' ? '&l=' + l : '';
            j.async = true;
            j.src =
                'https://www.googletagmanager.com/gtm.js?id=' + i + dl;
            f.parentNode.insertBefore(j, f);
        })(window, document, 'script', 'dataLayer', 'GTM-58R363H');
    </script>
    <script async="" src="https://script.hotjar.com/modules.6e8cbd39caed17f0d1c0.js" charset="utf-8"></script>
    <script async="" type="application/javascript" src="https://livetracker.live/horizontal/inits/widget.js"></script>

</body>
<script>
    $(document).ready(function() {


        $('.games-nav__item-pro').click(function() {

            // Close all content divs and reset icons
            $('.games-nav__tournaments-pro').slideToggle();
            $('.iconFont').removeClass('iconFont-icon-expandable-plus').addClass(
                'iconFont-icon-expandable-minus');

            // Slide down the clicked content div
            $(this).next('.games-nav__tournaments-pro').slideToggle();

            // Toggle the icon for the clicked button
            $(this).find('.iconFont').toggleClass(
                'iconFont-icon-expandable-minus iconFont-icon-expandable-plus');
        });
    });
</script>

<script>
    document.querySelector('.settings-title').addEventListener('click', function() {
        const settings = document.querySelector('.settings');
        settings.classList.toggle('_open');
    });
</script>

<script>
    document.addEventListener('DOMContentLoaded', () => {
        // Function to toggle the dropdown
        function toggleDropdown(event) {
            const target = event.currentTarget;
            const tournaments = target.nextElementSibling;
            const icon = target.querySelector('.games-nav__expand-pro i');

            if (tournaments.style.display === 'block') {
                tournaments.style.display = 'none';
                icon.classList.remove('iconFont-icon-expandable-minus');
                icon.classList.add('iconFont-icon-expandable-plus');
            } else {
                tournaments.style.display = 'block';
                icon.classList.remove('iconFont-icon-expandable-plus');
                icon.classList.add('iconFont-icon-expandable-minus');
            }
        }

        // Attach the event listener to all items with class '_football'
        const items = document.querySelectorAll('.games-nav__item-pro');
        items.forEach(item => {
            item.addEventListener('click', toggleDropdown);
        });
    });

    document.addEventListener('DOMContentLoaded', () => {
        const lobbyContent = document.querySelector('.lobby-content');

        function autoScroll() {
            lobbyContent.scrollTop = lobbyContent.scrollHeight;
        }

        // Call autoScroll function when new content is added
        const observer = new MutationObserver(() => {
            autoScroll();
        });

        // Observe changes in child elements
        observer.observe(lobbyContent, {
            childList: true
        });

        // Scroll to bottom initially
        autoScroll();
    });
</script>



</html>
