<?php $__env->startSection('master'); ?>
    <div class="card custom--card">
        <h5 class="card-header">
            <?php echo e(__($pageTitle)); ?>

        </h5>
        <div class="row">
            <div class="col-xl-12">
                <?php if($user->refBy): ?>
                    <div class="d-flex justify-content-center flex-wrap">
                        <h5>
                            <span class="mb-2"><?php echo app('translator')->get('You are referred by'); ?></span>
                            <span class="text--base"><?php echo e($user->refBy->username); ?></span>
                        </h5>
                    </div>
                <?php endif; ?>

                <div class="treeview-container <?php if(!$user->refBy): ?> mt-3 <?php endif; ?>">
                    <ul class="treeview">
                        <?php if($user->allReferrals->count() > 0 && $maxLevel > 0): ?>
                            <li class="items-expanded"> <?php echo e($user->username); ?>

                                <?php echo $__env->make($activeTemplate . 'partials.under_tree', ['user' => $user, 'layer' => 0, 'isFirst' => true], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </li>
                        <?php else: ?>
                            <div class="text-center">
                                <i class="text-muted fal fa-user-alt-slash fa-3x"></i><br>
                                <p class="text-muted"><?php echo app('translator')->get('No referred user found'); ?></p>
                            </div>
                        <?php endif; ?>
                    </ul>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('style-lib'); ?>
    <link href="<?php echo e(asset($activeTemplateTrue . 'css/treeView.css')); ?>" rel="stylesheet">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script-lib'); ?>
    <script src="<?php echo e(asset($activeTemplateTrue . 'js/treeView.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";
            $('.treeview').treeView();
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/cuce22pe/public_html/bet.newgenguru.com/core/resources/views/templates/basic/user/referral/users.blade.php ENDPATH**/ ?>