<?php $__env->startSection('panel'); ?>
    <?php
        $isGameDataExists = $game->id ?? false;
    ?>

    <form action="<?php echo e(route('admin.game.store', $isGameDataExists ?? 0)); ?>" method="POST" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <div class="row justify-content-center">
            <div class="col-xl-8">
                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-12">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('League'); ?></label>
                                    <select class="form-control select2 slug" name="league_id" required>
                                        <option value="" selected disabled><?php echo app('translator')->get('Select One'); ?></option>
                                        <?php $__currentLoopData = $leagues; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $league): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option data-name="<?php echo e($league->name); ?>" data-category="<?php echo e($league->category_id); ?>" value="<?php echo e($league->id); ?>" <?php if(@$game->league_id == $league->id): echo 'selected'; endif; ?>><?php echo e(__($league->name)); ?> -
                                                (<?php echo e(__($league->category->name)); ?>)
                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>

                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Team One'); ?></label>
                                    <select class="form-control select2 teams slug" name="team_one_id" required>
                                        <option value="" selected disabled><?php echo app('translator')->get('Select One'); ?></option>
                                    </select>
                                </div>
                            </div>

                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Team Two'); ?></label>
                                    <select class="form-control select2 teams slug" name="team_two_id" required>
                                        <option value="" selected disabled><?php echo app('translator')->get('Select One'); ?></option>
                                    </select>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Game Starts From'); ?></label>
                                    <input name="start_time" type="datetime-local" class="form-control bg--white" placeholder="<?php echo app('translator')->get('Start Date - End Date'); ?>" autocomplete="off" value="<?php echo e($isGameDataExists ? $game->start_time : old('start_time')); ?>">
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Bet Starts From'); ?></label>
                                    <input name="bet_start_time" type="datetime-local" class="form-control bg--white" placeholder="<?php echo app('translator')->get('Start Date - End Date'); ?>" autocomplete="off" value="<?php echo e($isGameDataExists ? $game->bet_start_time : old('bet_start_time')); ?>">
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Bet Ends At'); ?></label>
                                    <input name="bet_end_time" type="datetime-local" class="form-control bg--white" placeholder="<?php echo app('translator')->get('Start Date - End Date'); ?>" autocomplete="off" value="<?php echo e($isGameDataExists ? $game->bet_end_time : old('bet_end_time')); ?>">
                                </div>
                            </div>

                            <div class="col-12">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Slug'); ?></label>
                                    <input class="form-control" name="slug" type="text" value="<?php echo e(old('slug')); ?>" required>
                                </div>
                            </div>
                        </div>
                        <button class="btn btn--primary w-100 h-45" type="submit"><?php echo app('translator')->get('Submit'); ?></button>
                    </div>
                </div>
            </div>
        </div>
    </form>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('breadcrumb-plugins'); ?>
    <?php if (isset($component)) { $__componentOriginal3b9bf6c313f6db4d5c9389e5666c89a5 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal3b9bf6c313f6db4d5c9389e5666c89a5 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.back','data' => ['route' => ''.e(route('admin.game.index')).'']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('back'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['route' => ''.e(route('admin.game.index')).'']); ?> <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal3b9bf6c313f6db4d5c9389e5666c89a5)): ?>
<?php $attributes = $__attributesOriginal3b9bf6c313f6db4d5c9389e5666c89a5; ?>
<?php unset($__attributesOriginal3b9bf6c313f6db4d5c9389e5666c89a5); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal3b9bf6c313f6db4d5c9389e5666c89a5)): ?>
<?php $component = $__componentOriginal3b9bf6c313f6db4d5c9389e5666c89a5; ?>
<?php unset($__componentOriginal3b9bf6c313f6db4d5c9389e5666c89a5); ?>
<?php endif; ?>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script-lib'); ?>
    <script src="<?php echo e(asset('assets/admin/js/moment.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/global/js/daterangepicker.min.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('style-lib'); ?>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/global/css/daterangepicker.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";


            <?php if($isGameDataExists): ?>
                $('[name=slug]').val(`<?php echo e($game->slug); ?>`);
            <?php endif; ?>

            let isExistiTeamOne = "<?php echo e($isGameDataExists ? $game->team_one_id : old('team_one_id')); ?>";
            let isExistiTeamTwo = "<?php echo e($isGameDataExists ? $game->team_two_id : old('team_two_id')); ?>";
            let counter = false;

            <?php if(old('league_id')): ?>
                $('[name=league_id]').val(<?php echo e(old('league_id')); ?>)
            <?php endif; ?>

            $('.select2-basic').select2({
                dropdownParent: $('.card-body')
            });

            $('[name=league_id]').on('change', function() {
                if (!this.value) {
                    return;
                }
                let categoryId = $(this).find(":selected").data('category');

                $.ajax({
                    type: "get",
                    url: `<?php echo e(route('admin.game.teams', '')); ?>/${categoryId}`,
                    dataType: "json",
                    success: function(response) {
                        if (response.teams) {
                            $('.teams').removeAttr('disabled');
                            $('[name=team_one_id]').html(
                                `<option value="" disabled <?php echo e($isGameDataExists ? '' : 'selected'); ?>><?php echo app('translator')->get('Select One'); ?></option>`
                            );
                            $('[name=team_two_id]').html(
                                `<option value="" disabled <?php echo e($isGameDataExists ? '' : 'selected'); ?> ><?php echo app('translator')->get('Select One'); ?></option>`
                            );

                            $.each(response.teams, function(i, team) {
                                $('[name=team_one_id]').append(
                                    `<option data-team_one="${team.name}" value="${team.id}" ${(isExistiTeamOne == team.id) ? 'selected' : ''}> ${team.name}</option>`
                                );
                                $('[name=team_two_id]').append(
                                    `<option data-team_two="${team.name}" value="${team.id}" ${(isExistiTeamTwo == team.id) ? 'selected' : ''}> ${team.name}</option>`
                                );
                            });
                        } else {
                            $('[name=team_one_id]').html(
                                `<option value="" selected disabled><?php echo app('translator')->get('Select One'); ?></option>`);
                            $('[name=team_two_id]').html(
                                `<option value="" selected disabled><?php echo app('translator')->get('Select One'); ?></option>`);
                            $('#league_id').closest('.form-group').find(
                                '.select2-selection__rendered').text("<?php echo app('translator')->get('Select One'); ?>");
                            $('[name=league_id]').val('');

                            notify('error', response.error);
                        }
                    }
                });
            }).change();

            $('[name=team_one_id]').on('change', function() {

                let teamOneValue = this.value;
                let teamTwoValue = $('[name=team_two_id]').val();

                if (teamOneValue == teamTwoValue) {
                    $('#team_one_id').closest('.form-group').find('.select2-selection__rendered').text(
                        "<?php echo app('translator')->get('Select One'); ?>");
                    $('[name=team_one_id]').val('');
                    notify('error', "Same team can't be opponent");
                }
            });

            $('[name=team_two_id]').on('change', function() {
                let teamOneValue = $('[name=team_one_id]').val();
                let teamTwoValue = this.value;

                if (teamOneValue == teamTwoValue) {
                    $('#team_two_id').closest('.form-group').find('.select2-selection__rendered').text(
                        "<?php echo app('translator')->get('Select One'); ?>");
                    $('[name=team_two_id]').val('');
                    notify('error', "Same team can't be opponent");
                }
            });

            $('[name=start_time]').on('change', function() {
                makeGameSlug();
            });
            $('[name=bet_start_time]').on('change', function() {
                makeGameSlug();
            });
            $('[name=bet_end_time]').on('change', function() {
                makeGameSlug();
            });

            $('.slug').on('change', function() {
                makeGameSlug();
            });

            function makeGameSlug() {

                let slug = ``;
                if ($('[name=league_id]').val()) {
                    slug = `${$('[name=league_id]').find(':selected').data('name')} `;
                }

                if ($(document).find('[name=team_one_id]').val()) {
                    slug += `${$(document).find('[name=team_one_id]').find(':selected').html()} `;
                }
                if ($('[name=team_two_id]').val()) {
                    slug += `${' vs ' + $('[name=team_two_id]').find(':selected').html()} `;
                }
                if ($('[name=start_time]').val()) {
                    let startTime = $('[name=start_time]').val();
                    slug += `${startTime.replace(/:/g, "-")} `;
                }
                if ($('[name=bet_end_time]').val()) {
                    let endTime = $('[name=bet_end_time]').val();
                    slug += `${endTime.replace(/:/g, "-")} `;
                }

                slug = slug.trim();
                slug = slug.replace(/\s+/g, '-').toLowerCase();
                $('[name=slug]').val(slug);
            }

        })(jQuery)
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/cuce22pe/public_html/bet.newgenguru.com/core/resources/views/admin/game/form.blade.php ENDPATH**/ ?>