<?php $__env->startSection('master'); ?>
    <div class="row justify-content-end mb-3">
        <div class="col-xl-5 col-md-8">
            <form>
                <div class="input-group">
                    <input class="form-control form--control" name="search" type="text" value="<?php echo e(request()->search); ?>" placeholder="<?php echo app('translator')->get('Search by Transaction'); ?>">
                    <button class="input-group-text bg--base text-white"><i class="las la-search"></i></button>
                </div>
            </form>
        </div>
    </div>

    <table class="table-responsive--md custom--table custom--table-separate table">
        <thead>
            <tr>
                <th><?php echo app('translator')->get('Gateway | Transaction'); ?></th>
                <th><?php echo app('translator')->get('Initiated'); ?></th>
                <th><?php echo app('translator')->get('Amount'); ?></th>
                <th><?php echo app('translator')->get('Conversion'); ?></th>
                <th><?php echo app('translator')->get('Status'); ?></th>
                <th><?php echo app('translator')->get('Details'); ?></th>
            </tr>
        </thead>

        <tbody>
            <?php $__empty_1 = true; $__currentLoopData = $withdraws; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $withdraw): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <?php
                    $details = [];
                    foreach ($withdraw->withdraw_information as $key => $info) {
                        $details[] = $info;
                        if ($info->type == 'file') {
                            $details[$key]->value = route('user.download.attachment', encrypt(getFilePath('verify') . '/' . $info->value));
                        }
                    }
                ?>
                <tr>
                    <td>
                        <div>
                            <span class="fw-bold"><span class="text-primary"> <?php echo e(__(@$withdraw->method->name)); ?></span></span>
                            <br>
                            <small><?php echo e($withdraw->trx); ?></small>
                        </div>
                    </td>
                    <td>
                        <span><?php echo e(showDateTime($withdraw->created_at)); ?> <br> <?php echo e(diffForHumans($withdraw->created_at)); ?></span>
                    </td>
                    <td>
                        <div>
                            <?php echo e(showAmount($withdraw->amount)); ?> - <span class="text--danger" data-bs-toggle="tooltip" title="<?php echo app('translator')->get('Processing Charge'); ?>"><?php echo e(showAmount($withdraw->charge)); ?> </span>
                            <br>
                            <strong data-bs-toggle="tooltip" title="<?php echo app('translator')->get('Amount after charge'); ?>">
                                <?php echo e(showAmount($withdraw->amount - $withdraw->charge)); ?>

                            </strong>
                        </div>
                    </td>
                    <td>
                        <div>
                            <?php echo e(showAmount(1)); ?> = <?php echo e(showAmount($withdraw->rate, currencyFormat: false)); ?> <?php echo e(__($withdraw->currency)); ?>

                            <br>
                            <strong><?php echo e(showAmount($withdraw->final_amount, currencyFormat: false)); ?> <?php echo e(__($withdraw->currency)); ?></strong>
                        </div>
                    </td>
                    <td>
                        <?php echo $withdraw->statusBadge ?>
                    </td>
                    <td>
                        <button class="btn btn--sm btn--base detailBtn"
                                data-user_data="<?php echo e(json_encode($details)); ?>"
                                <?php if($withdraw->status == Status::PAYMENT_REJECT): ?> data-admin_feedback="<?php echo e($withdraw->admin_feedback); ?>" <?php endif; ?>>
                            <i class="la la-desktop"></i>
                        </button>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td class="text-muted text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>

    <div class="mt-4 align-items-center pagination-wrapper">
        <?php echo e($withdraws->links()); ?>

    </div>

    <div class="modal fade custom--modal" id="detailModal" aria-hidden="true" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo app('translator')->get('Details'); ?></h5>
                    <button class="close" data-bs-dismiss="modal" type="button" aria-label="Close">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="deposit-card">
                        <ul class="deposit-card__list list userData">
                        </ul>
                    </div>
                    <div class="feedback mt-2 pt-1 pb-1"></div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";
            $('.detailBtn').on('click', function() {
                var modal = $('#detailModal');
                var userData = $(this).data('user_data');
                console.log(userData);
                var html = ``;
                userData.forEach(element => {
                    if (element.type != 'file') {
                        html += `
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            <span>${element.name}</span>
                            <span">${element.value}</span>
                        </li>`;
                    } else {
                        html += `
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            <span>${element.name}</span>
                            <span"><a href="${element.value}"><i class="fa-regular fa-file"></i> <?php echo app('translator')->get('Attachment'); ?></a></span>
                        </li>`;
                    }
                });
                modal.find('.userData').html(html);

                if ($(this).data('admin_feedback') != undefined) {
                    var adminFeedback = `
                        <div class="my-3">
                            <strong><?php echo app('translator')->get('Admin Feedback'); ?></strong>
                            <p>${$(this).data('admin_feedback')}</p>
                        </div>
                    `;
                } else {
                    var adminFeedback = '';
                }

                modal.find('.feedback').html(adminFeedback);

                modal.modal('show');
            });

            var tooltipTriggerList = [].slice.call(document.querySelectorAll('[title], [data-title], [data-bs-title]'))
            tooltipTriggerList.map(function(tooltipTriggerEl) {
                return new bootstrap.Tooltip(tooltipTriggerEl)
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\Laravel\bet\core\resources\views/templates/basic/user/withdraw/log.blade.php ENDPATH**/ ?>