<?php $__env->startSection('panel'); ?>
    <div class="row">
        <div class="col-lg-12">
            <div class="card b-radius--10">
                <div class="card-body p-0">
                    <div class="table-responsive--md table-responsive">
                        <table class="table--light style--two table">
                            <thead>
                                <tr>
                                    <th><?php echo app('translator')->get('Bet Number'); ?></th>
                                    <th><?php echo app('translator')->get('Type'); ?></th>
                                    <th><?php echo app('translator')->get('Stake Amount'); ?></th>
                                    <th><?php echo app('translator')->get('Return'); ?></th>
                                    <th><?php echo app('translator')->get('Status'); ?></th>
                                    <th><?php echo app('translator')->get('Action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $bets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bet): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td>
                                            <span><?php echo e(__($bet->bet_number)); ?></span>
                                            <br>
                                            <a href="<?php echo e(route('admin.users.detail', @$bet->user_id)); ?>"><span>@</span><?php echo e(@$bet->user->username); ?></a>
                                        </td>

                                        <td> <?php echo $bet->betTypeBadge ?> </td>
                                        <td> <?php echo e(showAmount($bet->stake_amount)); ?> </td>
                                        <td> <?php echo e(showAmount($bet->return_amount)); ?> </td>
                                        <td> <?php echo $bet->betStatusBadge ?> </td>
                                        <td>
                                            <button class="btn btn-sm btn-outline--primary bet-detail" data-bet_details='<?php echo e($bet->bets); ?>' type="button">
                                                <i class="las la-desktop"></i> <?php echo app('translator')->get('Detail'); ?>
                                            </button>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>

                <?php if($bets->hasPages()): ?>
                    <div class="card-footer py-4">
                        <?php echo e(paginateLinks($bets)); ?>

                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <div class="modal fade" id="betDetailModal" role="dialog" aria-labelledby="modalTitleId" aria-hidden="true" tabindex="-1">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="m-0"><?php echo app('translator')->get('Bet Detail'); ?></h5>
                    <span class="close" data-bs-dismiss="modal" type="button" aria-label="Close">
                        <i class="las la-times"></i>
                    </span>
                </div>
                <div class="modal-body">
                    <div class="table-responsive--md table-responsive">
                        <table class="table--light style--two table">
                            <thead>
                                <tr>
                                    <th><?php echo app('translator')->get('Game'); ?></th>
                                    <th><?php echo app('translator')->get('Market'); ?></th>
                                    <th><?php echo app('translator')->get('Option'); ?></th>
                                    <th><?php echo app('translator')->get('Odds'); ?></th>
                                    <th><?php echo app('translator')->get('Status'); ?></th>
                                </tr>
                            </thead>
                            <tbody></tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('breadcrumb-plugins'); ?>
    <?php if (isset($component)) { $__componentOriginale48b4598ffc2f41a085f001458a956d1 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginale48b4598ffc2f41a085f001458a956d1 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.search-form','data' => ['placeholder' => 'Search by bet number']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('search-form'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['placeholder' => 'Search by bet number']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginale48b4598ffc2f41a085f001458a956d1)): ?>
<?php $attributes = $__attributesOriginale48b4598ffc2f41a085f001458a956d1; ?>
<?php unset($__attributesOriginale48b4598ffc2f41a085f001458a956d1); ?>
<?php endif; ?>
<?php if (isset($__componentOriginale48b4598ffc2f41a085f001458a956d1)): ?>
<?php $component = $__componentOriginale48b4598ffc2f41a085f001458a956d1; ?>
<?php unset($__componentOriginale48b4598ffc2f41a085f001458a956d1); ?>
<?php endif; ?>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";
            $('.bet-detail').on('click', function(e) {
                var modal = $('#betDetailModal');
                modal.find('tbody').html('');
                var betDetails = $(this).data('bet_details');
                var tableRow = ``;
                $.each(betDetails, function(index, detail) {
                    var status = ``;
                    if (detail.status == 1) {
                        status = `<span class="badge badge--success"><?php echo app('translator')->get('Won'); ?></span>`
                    } else if (detail.status == 2) {
                        status = `<span class="badge badge--warning"><?php echo app('translator')->get('Pending'); ?></span>`
                    } else if (detail.status == 3) {
                        status = `<span class="badge badge--danger"><?php echo app('translator')->get('Lose'); ?></span>`
                    } else if (detail.status == 4) {
                        status = `<span class="badge badge--primary"><?php echo app('translator')->get('Refund'); ?></span>`
                    }
                    tableRow += `<tr>
                                    <td data-label="<?php echo app('translator')->get('Game'); ?>">
                                        ${detail.option.question.game.team_one.short_name}
                                        <span class="text--base"><?php echo app('translator')->get('vs'); ?></span>
                                        ${detail.option.question.game.team_two.short_name}
                                    </td>
                                    <td data-label="<?php echo app('translator')->get('Market'); ?>">${detail.option.question.title}</td>
                                    <td data-label="<?php echo app('translator')->get('Option'); ?>">${detail.option.name}</td>
                                    <td data-label="<?php echo app('translator')->get('Odds'); ?>">${Math.abs(detail.option.odds)}</td>
                                    <td data-label="<?php echo app('translator')->get('Status'); ?>">
                                        ${status}
                                    </td>
                                </tr>`
                });
                modal.find('tbody').html(tableRow);
                modal.modal('show');
            });
        })(jQuery)
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/cuce22pe/public_html/bet.newgenguru.com/core/resources/views/admin/bet/index.blade.php ENDPATH**/ ?>