<?php $__env->startSection('master'); ?>
    <div class="row justify-content-end mb-3">
        <div class="col-xl-5 col-md-8">
            <form>
                <div class="input-group">
                    <input class="form-control form--control" name="search" type="text" value="<?php echo e(request()->search); ?>" placeholder="<?php echo app('translator')->get('Search by Transaction'); ?>">
                    <button class="input-group-text bg--base text-white"><i class="las la-search"></i></button>
                </div>
            </form>
        </div>
    </div>

    <div class="bet-table">
        <table class="table-responsive--md custom--table custom--table-separate table">
            <thead>
                <tr>
                    <th><?php echo app('translator')->get('Gateway'); ?> | <?php echo app('translator')->get('TRX. No.'); ?></th>
                    <th><?php echo app('translator')->get('Initiated'); ?></th>
                    <th><?php echo app('translator')->get('Amount'); ?></th>
                    <th><?php echo app('translator')->get('Conversion'); ?></th>
                    <th><?php echo app('translator')->get('Status'); ?></th>
                    <th><?php echo app('translator')->get('Details'); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $deposits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $deposit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td>
                            <div class="">
                                <span class="fw-bold">
                                    <span class="text-primary">
                                        <?php if($deposit->method_code < 5000): ?>
                                            <?php echo e(__(@$deposit->gateway->name)); ?>

                                        <?php else: ?>
                                            <?php echo app('translator')->get('Google Pay'); ?>
                                        <?php endif; ?>
                                    </span>
                                </span>
                                <br>
                                <small> <?php echo e($deposit->trx); ?> </small>
                            </div>
                        </td>

                        <td>
                            <span><?php echo e(showDateTime($deposit->created_at)); ?><br><?php echo e(diffForHumans($deposit->created_at)); ?></span>
                        </td>
                        <td>
                            <div>
                                <?php echo e(showAmount($deposit->amount)); ?> + <span class="text--danger" data-bs-toggle="tooltip" title="<?php echo app('translator')->get('Processing Charge'); ?>"><?php echo e(showAmount($deposit->charge)); ?> </span>
                                <br>
                                <strong data-bs-toggle="tooltip" title="<?php echo app('translator')->get('Amount with charge'); ?>">
                                    <?php echo e(showAmount($deposit->amount + $deposit->charge)); ?>

                                </strong>
                            </div>
                        </td>
                        <td>
                            <div>
                                <?php echo e(showAmount(1)); ?> = <?php echo e(showAmount($deposit->rate, currencyFormat: false)); ?> <?php echo e(__($deposit->method_currency)); ?>

                                <br>
                                <strong><?php echo e(showAmount($deposit->final_amount, currencyFormat: false)); ?> <?php echo e(__($deposit->method_currency)); ?></strong>
                            </div>
                        </td>
                        <td>
                            <?php echo $deposit->statusBadge ?>
                        </td>
                        <?php
                            $details = [];
                            if ($deposit->method_code >= 1000 && $deposit->method_code <= 5000) {
                                foreach (@$deposit->detail ?? [] as $key => $info) {
                                    $details[] = $info;
                                    if ($info->type == 'file') {
                                        $details[$key]->value = route('user.download.attachment', encrypt(getFilePath('verify') . '/' . $info->value));
                                    }
                                }
                            }
                        ?>

                        <td>
                            <?php if($deposit->method_code >= 1000 && $deposit->method_code <= 5000): ?>
                                <a href="javascript:void(0)" class="btn btn--base btn--sm detailBtn" data-info="<?php echo e(json_encode($details)); ?>"
                                   <?php if($deposit->status == Status::PAYMENT_REJECT): ?> data-admin_feedback="<?php echo e($deposit->admin_feedback); ?>" <?php endif; ?>>
                                    <i class="fas fa-desktop"></i>
                                </a>
                            <?php else: ?>
                                <button class="btn btn--success btn--sm automatic-payment" type="button" data-bs-toggle="tooltip" title="<?php echo app('translator')->get('Automatically processed'); ?>">
                                    <i class="fas fa-check"></i>
                                </button>
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="100%" class="text-center"><?php echo e(__($emptyMessage)); ?></td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <div class="mt-4 align-items-center pagination-wrapper">
        <?php echo e($deposits->links()); ?>

    </div>

    <div id="detailModal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo app('translator')->get('Details'); ?></h5>
                    <span type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <i class="las la-times"></i>
                    </span>
                </div>
                <div class="modal-body">
                    <ul class="list-group userData mb-2">
                    </ul>
                    <div class="feedback"></div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-dark btn-sm" data-bs-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('style'); ?>
    <style>
        .input-group-text {
            border-radius: 0 5px 5px 0 !important;
        }

        .automatic-payment {
            color: hsl(var(--white));
            background: hsl(var(--success));
            cursor: context-menu !important;
        }
    </style>
<?php $__env->stopPush(); ?>



<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";

            $('.detailBtn').on('click', function() {
                var modal = $('#detailModal');

                var userData = $(this).data('info');
                var html = '';
                if (userData) {
                    userData.forEach(element => {
                        if (element.type != 'file') {
                            html += `<li class="d-flex flex-wrap aligh-items-center justify-content-between">
                                        <span class="deposit-card__title fw-bold">
                                            ${element.name}
                                        </span>
                                        <span class="deposit-card__amount">
                                            ${element.value}
                                        </span>
                                    </li>`;
                        }
                    });
                }

                modal.find('.userData').html(html);

                if ($(this).data('admin_feedback') != undefined) {
                    var adminFeedback = `
                        <div class="my-3">
                            <strong><?php echo app('translator')->get('Admin Feedback'); ?></strong>
                            <p>${$(this).data('admin_feedback')}</p>
                        </div>
                    `;
                } else {
                    var adminFeedback = '';
                }

                if (adminFeedback) {
                    modal.find('.feedback').html(adminFeedback).addClass('deposit-card');
                } else {
                    modal.find('.feedback').removeClass('deposit-card').empty();
                }

                modal.modal('show');
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\Laravel\bet\core\resources\views/templates/basic/user/deposit_history.blade.php ENDPATH**/ ?>